vcpkg_check_linkage(ONLY_STATIC_LIBRARY)

vcpkg_fail_port_install(ON_TARGET "UWP")

vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO ampl/asl
    REF 934d34719c8a620fcf16ae5a3c00c326eb22e748
    SHA512 b6fcb3dcb53a53d975666db1643d7ea518246e8fb6745621ce4b63de4393f7767844e9241baa6fdf1a45c241a9aa0866844c47deec0020313278128cccff6869
    HEAD_REF master
    PATCHES
        workaround-msvc-optimizer-ice.patch
        fix-crt-linkage.patch # CRT linkage uses C/CXX FLAGS in vcpkg
        install-extra-headers.patch
        install-targets.patch
)

vcpkg_configure_cmake(
    SOURCE_PATH ${SOURCE_PATH}
    PREFER_NINJA
    OPTIONS
        -DBUILD_MCMODELLARGE=OFF
        -DBUILD_DYNRT_LIBS=OFF # CRT linkage uses C/CXX FLAGS in vcpkg
        -DBUILD_MT_LIBS=OFF # CRT linkage uses C/CXX FLAGS in vcpkg
        -DBUILD_CPP=ON
)

vcpkg_install_cmake()

vcpkg_copy_pdbs()

vcpkg_fixup_cmake_targets(CONFIG_PATH share/unofficial-asl TARGET_PATH share/unofficial-asl)

file(REMOVE_RECURSE ${CURRENT_PACKAGES_DIR}/debug/include)

# from ampl-mp license
file(INSTALL ${CURRENT_PORT_DIR}/copyright DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT})
