# Contributing to Beast

Thank you for taking the time to read this document!

:heart_eyes: **please star the Boost.Beast repository!** :heart_eyes:

First make sure you're on the
[official repository page](https://github.com/boostorg/beast/blob/master/CONTRIBUTING.md),
then just press the button labeled "star" in the top right of the page
to give Beast a star! Your stars create generate additional visibility,
which leads to more users, more bug reports, more fixes, more testing,
more features, and a better product!

<a href="https://github.com/boostorg/beast/blob/master/CONTRIBUTING.md">
<img width="400" height = "150" alt = "Please Star the Repository"
    src="https://raw.githubusercontent.com/vinniefalco/BeastAssets/master/StarTheRepo.png">
</a>

Click the image above to make sure you're on the official
Boost repository page so you can give Beast a star!

# Ways to Contribute

No contribution to Beast is too big or too small! We are
always happy to see user participation in all of its forms.
Here are some of the ways that you can contribute (this is
by no means an exhaustive list):

* Submit a
  [bug report](https://github.com/boostorg/beast/issues).
  We love hearing about broken things, so
  that we can fix them. Any problem is fair game, this includes
  the documentation examples, tests, and repository as well as the
  library itself. Bug reports should be opened on the
  [Issues](https://github.com/boostorg/beast/issues) page.

* Provide
  [feedback](https://github.com/boostorg/beast/issues).
  about the library. If you have used, are using,
  or are thinking about using the library we want to hear about it!
  The more information you provide, the better we will be able
  to ensure that Beast meets your needs. You can provide feedback
  as an issue, or email the author directly.

* Test Beast. When changes are made, they are submitted as a
  [Pull Request](https://github.com/boostorg/beast/pulls).
  Everyone is welcome to examine these upcoming changes, test them,
  and report on the results. This form of quality assurance is very
  helpful so we can keep delivering a great product. Consider
  subscribing to repository notifications to get alerted to new
  pull requests.

* Code Review on
  [Pull Requests](https://github.com/boostorg/beast/pulls).
  This is one of the most valuable ways to contribute, because it helps
  to improve code and features, and helps to find bugs, before the code
  gets merged. A little bit of time investment from just a few people on
  each pull request goes a **long** way to increasing the quality of the
  final product. For tips on how to participate in pull requests please
  view the
  [README.md](https://github.com/boostorg/beast#contributing-we-need-your-help).

* Use Beast in your next application! At the end of the day, it is the
  goal of the library to provide utility to users so the best way you
  can contribute is simply to use the library!
