% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{make_readable_file}
\alias{make_readable_file}
\title{Handle a range of possible input sources}
\usage{
make_readable_file(file, mmap = TRUE, compression = NULL, filesystem = NULL)
}
\arguments{
\item{file}{A character file name, \code{raw} vector, or an Arrow input stream}

\item{mmap}{Logical: whether to memory-map the file (default \code{TRUE})}

\item{compression}{If the file is compressed, created a \link{CompressedInputStream}
with this compression codec, either a \link{Codec} or the string name of one.
If \code{NULL} (default) and \code{file} is a string file name, the function will try
to infer compression from the file extension.}

\item{filesystem}{If not \code{NULL}, \code{file} will be opened via the
\code{filesystem$OpenInputFile()} filesystem method, rather than the \code{io} module's
\code{MemoryMappedFile} or \code{ReadableFile} constructors.}
}
\value{
An \code{InputStream} or a subclass of one.
}
\description{
Handle a range of possible input sources
}
\keyword{internal}
